# 路径总和 II

<p>给你二叉树的根节点 <code>root</code> 和一个整数目标和 <code>targetSum</code> ，找出所有 <strong>从根节点到叶子节点</strong> 路径总和等于给定目标和的路径。</p>

<p><strong>叶子节点</strong> 是指没有子节点的节点。</p>

<div class="original__bRMd">
<div>


<p><strong>示例 1：</strong></p>
<img alt="" src="https://img-blog.csdnimg.cn/img_convert/abdc6911d9d9ee1b12dcdbb1945a1ab2.png#pic_center" />
<pre>
<strong>输入：</strong>root = [5,4,8,11,null,13,4,7,2,null,null,5,1], targetSum = 22

<strong>输出：</strong>[[5,4,11,2],[5,8,4,5]]
</pre>

<p><strong>示例 2：</strong></p>
<img alt="" src="https://img-blog.csdnimg.cn/img_convert/9bc801134935f549d425954a120f1cc3.png#pic_center" />
<pre>
<strong>输入：</strong>root = [1,2,3], targetSum = 5

<strong>输出：</strong>[]
</pre>

<p><strong>示例 3：</strong></p>

<pre>
<strong>输入：</strong>root = [1,2], targetSum = 0

<strong>输出：</strong>[]
</pre>



<p><strong>提示：</strong></p>

<ul>
	<li>树中节点总数在范围 <code>[0, 5000]</code> 内</li>
	<li><code>-1000 <= Node.val <= 1000</code></li>
	<li><code>-1000 <= targetSum <= 1000</code></li>
</ul>
</div>
</div>

<p>以下<span style="color:red">错误</span>的选项是？</p>

## aop

### before

```c
#include <bits/stdc++.h>
using namespace std;

struct TreeNode
{
    int val;
    TreeNode *left;
    TreeNode *right;
    TreeNode() : val(0), left(nullptr), right(nullptr) {}
    TreeNode(int x) : val(x), left(nullptr), right(nullptr) {}
    TreeNode(int x, TreeNode *left, TreeNode *right) : val(x), left(left), right(right) {}
};

```

### after

```c

```

## 答案

```c
class Solution
{
public:
    vector<vector<int>> pathSum(TreeNode *root, int sum)
    {
        int pos = 0;
        vector<int> path;
        vector<vector<int>> result;
        dfs(root, sum, pos, path, result);
        return result;
    }

private:
    void dfs(TreeNode *root, int sum, int &pos, vector<int> &path, vector<vector<int>> &result)
    {
        if (root == NULL)
            return;
        pos += root->val;
        path.push_back(root->val);
        if (!root->left && !root->right && pos == sum)
            result.push_back(path);
        dfs(root->left, sum, pos, path, result);
        dfs(root->right, sum, pos, path, result);
        path.pop_back();
    }
};
```
## 选项

### A

```c
class Solution
{
public:
    void find(TreeNode *node, vector<vector<int>> &result, vector<int> &path, int sum)
    {
        path.push_back(node->val);
        if (node->left == NULL && node->right == NULL && sum == node->val)
        {
            result.push_back(path);
            return;
        }
        if (node->left != NULL)
        {
            find(node->left, result, path, sum - node->val);
            path.pop_back();
        }

        if (node->right != NULL)
        {
            find(node->right, result, path, sum - node->val);
            path.pop_back();
        }
    }

    vector<vector<int>> pathSum(TreeNode *root, int sum)
    {

        vector<vector<int>> result;
        vector<int> path;
        if (root == NULL)
        {
            return result;
        }
        find(root, result, path, sum);
        return result;
    }
};
```

### B

```c
class Solution
{
public:
    vector<vector<int>> pathSum(TreeNode *root, int sum)
    {
        vector<vector<int>> res;
        if (!root)
            return res;
        vector<int> temp;
        dfs(root, res, temp, sum);
        return res;
    }

    void dfs(TreeNode *root, vector<vector<int>> &res, vector<int> temp, int sum)
    {
        temp.push_back(root->val);
        if (!root->left && !root->right && 0 == sum - root->val)
            res.push_back(temp);
        if (root->left)
            dfs(root->left, res, temp, sum - root->val);
        if (root->right)
            dfs(root->right, res, temp, sum - root->val);
    }
};
```

### C

```c
class Solution
{
public:
    vector<vector<int>> pathSum(TreeNode *root, int targetSum)
    {
        DFS(root, targetSum);
        return result;
    }
    void DFS(TreeNode *root, int targetSum)
    {
        if (root == nullptr)
            return;
        tmp_path.emplace_back(root->val);
        targetSum -= root->val;
        if (root->left == nullptr && root->right == nullptr && targetSum == 0)
        {
            result.emplace_back(tmp_path);
        }
        DFS(root->left, targetSum);
        DFS(root->right, targetSum);
        tmp_path.pop_back();
    }

private:
    vector<vector<int>> result;
    vector<int> tmp_path;
};
```
